%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      GenSensorData3.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    This routine determines all the possible sensor 
%                 settings that will be used for a 3-color sensor and 
%                 saves the result in the file SensorData3.mat. Each 
%                 row contains the following:
%                 Width1 Width2 Width3 Pos1 Pos2 Pos3
%--------------------------------------------------------------------------

if ieNotDefined('numSensors'), numSensors = 3 ; end
NumSims = 1000;     % Number of simulations that we would like to do

% Initialize the project settings
InitializeProject;

% Settings
%--------------------------------------------------------------------------
sensorPosSpacing = 20;      % Wavelength between different sensor options
sensorWidthSpacing = 7.5;
minSensorWidth = 25;
maxSensorWidth = 55;
minGreen = 500;
maxGreen = 600;
%--------------------------------------------------------------------------

% Set up a matrix with all possible sensor positions 
sensorPos_all = [];
sensorWidth_all = [];
sensorSettings_all = [];

% Calculate the sensor widths
%-----------------------------
for Width1 = minSensorWidth:sensorWidthSpacing:maxSensorWidth
   for Width2 =  minSensorWidth:sensorWidthSpacing:maxSensorWidth
      for Width3 = minSensorWidth:sensorWidthSpacing:maxSensorWidth
          sensorWidth_all = [sensorWidth_all ; Width1 Width2 Width3];
      end
   end
end

% Calculate the sensor positions
%--------------------------------
for Pos2 = minGreen:sensorPosSpacing:maxGreen,
    for Pos1 = minWavelength:sensorPosSpacing:Pos2 - sensorPosSpacing,
        for Pos3 = (Pos2 + sensorPosSpacing):sensorPosSpacing:maxWavelength
            sensorPos_all = [sensorPos_all; Pos1 Pos2 Pos3];
        end
    end
end

% Combine the positions and the widths - Faster version
%--------------------------------------------------------
NumRows = size(sensorWidth_all,1)*size(sensorPos_all,1);
NumCols = size(sensorWidth_all,2) + size(sensorPos_all,2);
NewStage = zeros(NumRows, NumCols);
OldStage = sensorPos_all;

NSOld = size(OldStage,1);
NumWidths = size(sensorWidth_all,1);
for WIdx = 1:1:NumWidths;
    %fprintf('Width %d of %d \n',WIdx,NumWidths);
    NewStage(((WIdx-1)*NSOld+1):(WIdx*NSOld),:) = [repmat(sensorWidth_all(WIdx,:),NSOld,1), OldStage];
end

sensorSettings_all = NewStage;

% Sample only NumSims of these
disp('Number of sensors, before choosing uniformly:');
size(sensorSettings_all,1)
SampleRows = round(rand(NumSims,1)*size(sensorSettings_all,1));
[Min,MinIdx] = min(SampleRows);
[Max,MaxIdx] = max(SampleRows);

if(Min < 1)
   SampleRows(MinIdx) = 1;
end
if(Max > size(sensorSettings_all,1))
   SampleRows(MinIdx) = size(sensorSettings_all,1);
end

% Save the names of te parameters that we are changing
sensorSettings_Names = {'Width1','Width2','Width3','Pos1','Pos2','Pos3'};

% Save the sensor data
sensorSettings = sensorSettings_all(SampleRows,:);
save('SensorData3.mat', 'sensorSettings_Names', 'sensorSettings');

% Display what all the sensor settings are:
disp(sensorSettings_Names)
sensorSettings


